// This interface defines gravitational interaction.

package SpaceWar;

import java.awt.geom.*;
import java.util.*;

interface Gravity {

	// Compute gravitational acceleration and direction.  This
	// interface is for single-body gravitational interactions,
	// as is appropriate for interactions near the surface of
	// a large star or planet.
	
	void computeGravity(Point2D.Double a1, Point2D.Double p1, double m1);

	// Compute gravitational acceleration and direction.
	// This interface is for pairwise gravitational attraction,
	// as is appropriate for free-fall interactions.
	
	void computeGravity(Point2D.Double a1,
						Point2D.Double p1,
						double m1,
						double r1,
						Point2D.Double a2,
						Point2D.Double p2,
						double m2,
						double r2);
	
}
