// This class defines inverse Newtonian gravitational interaction.
// This type of gravity repels rather than attracts.

package SpaceWar;

import java.awt.geom.*;
import java.util.*;

class GravityInverseNewtonian implements Gravity {

	//////////////////////////////////////////////////////////////////////
	//
	// Parameters.

	static double G = 1.0e-9;

	//////////////////////////////////////////////////////////////////////
	//
	// Instance Variables.

	protected MetricSpace metric;			// Defines geometry/movement
	protected Point2D.Double u1;
	protected Point2D.Double u2;

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.
	
	public GravityInverseNewtonian(MetricSpace newMetric) {
		metric = newMetric;
		u1 = new Point2D.Double();
		u2 = new Point2D.Double();
	}

	// Compute single-hour gravitational acceleration and direction.
	// This does nothing, as this is a strictly free-fall version of
	// gravity.
	
	public  void computeGravity(Point2D.Double a1,
								Point2D.Double p1,
								double m1) {
	}

	// Compute pairwise gravitational acceleration and direction.
	// This is a "repulsive" version of the familiar inverse-square law.
	
	public  void computeGravity(Point2D.Double a1,
								Point2D.Double p1,
								double m1,
								double r1,
								Point2D.Double a2,
								Point2D.Double p2,
								double m2,
								double r2) {
		double d;
		double f;
		
		d = metric.computeDistance(p1, p2, u1, u2);
		if (d < r1 + r2) {
			return;
		}
		f = G * m1 * m2 / (d * d);
		
		metric.scaleAcceleration(u1, -f / m1);
		metric.addAcceleration(a1, u1);

		metric.scaleAcceleration(u2, -f / m2);
		metric.addAcceleration(a2, u2);
	}
}
