// This class defines Newtonian gravitational interaction.

package SpaceWar;

import java.awt.geom.*;
import java.util.*;

class GravityNewtonian implements Gravity {

	//////////////////////////////////////////////////////////////////////
	//
	// Parameters.

	protected double G = 1.0e-9;
	protected double minMassSquared = 1000;

	//////////////////////////////////////////////////////////////////////
	//
	// Instance Variables.

	protected MetricSpace metric;			// Defines geometry/movement
	protected Point2D.Double u1;
	protected Point2D.Double u2;

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.
	
	public GravityNewtonian(MetricSpace newMetric) {
		metric = newMetric;
		u1 = new Point2D.Double();
		u2 = new Point2D.Double();
	}

	// Compute single-object gravitational acceleration and direction.
	// This is a free-fall gravitational model, so this does nothing.
	
	public  void computeGravity(Point2D.Double a1,
								Point2D.Double p1,
								double m1) {
	}

	// Compute pairwise gravitational acceleration and direction.
	// This is the classical inverse-square law.
	
	public  void computeGravity(Point2D.Double a1,
								Point2D.Double p1,
								double m1,
								double r1,
								Point2D.Double a2,
								Point2D.Double p2,
								double m2,
								double r2) {
		double d;
		double f;
		double mm = m1 * m2;
		
		if (mm < minMassSquared) {
			return;
		}
		d = metric.computeDistance(p1, p2, u1, u2);
		if (d < r1 + r2) {
			return;
		}
		f = G * mm / (d * d);
		
		metric.scaleAcceleration(u1, f / m1);
		metric.addAcceleration(a1, u1);

		metric.scaleAcceleration(u2, f / m2);
		metric.addAcceleration(a2, u2);
	}
}
