// This class defines terrestrial gravitational interaction.
// In other words, the effect one would see on the surface of a large
// planet.

package SpaceWar;

import java.awt.geom.*;
import java.util.*;

class GravityTerrestrial extends GravityNewtonian {

	//////////////////////////////////////////////////////////////////////
	//
	// Parameters.

	static double Gc = .5;

	//////////////////////////////////////////////////////////////////////
	//
	// Instance Variables.

	protected Point2D.Double g;

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.
	
	public GravityTerrestrial(MetricSpace newMetric) {
		super(newMetric);
		g = new Point2D.Double(0., -Gc);
	}

	// Compute single-object gravitational acceleration and direction.
	// This simulates the "large planet"'s gravity well.
	
	public  void computeGravity(Point2D.Double a1,
								Point2D.Double p1,
								double m1) {
		metric.addAcceleration(a1, g);
	}

	// The computation of pairwise gravitational acceleration
	// is inherited from the superclass.
	
}
