package SpaceWar;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class RemoteControl extends JFrame implements ControlledObject{

  private boolean isKeyboardListener = true;
  private boolean isMouseListener = false;
  boolean mousePressed = false;

  private ControlledObject primaryListener = null;
  private ControlledObject secondaryListener = null;

  GridLayout gridLayout1 = new GridLayout();
  JButton jButton7 = new JButton();
  JButton jButton4 = new JButton();
  JButton jButton5 = new JButton();
  JButton jButton8 = new JButton();
  JButton jButton6 = new JButton();
  JButton jButton1 = new JButton();
  JButton jButton9 = new JButton();
  JButton jButton2 = new JButton();
  JButton jButton3 = new JButton();

  //Construct the frame
  public RemoteControl() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try  {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void setPrimaryListener(ControlledObject cl)
  {
    primaryListener = cl;
  }

  public void setSecondaryListener(ControlledObject cl)
  {
    secondaryListener = cl;
  }

  public void setAsKeyboardListener()
  {
    isKeyboardListener = true;
    isMouseListener = false;
  }

  public void setAsMouseListener()
  {
    isKeyboardListener = false;
    isMouseListener = true;
  }

  //Component initialization
  private void jbInit() throws Exception  {
    jButton7.setText("Restart"); // Press 7
    jButton7.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton7_actionPerformed(e);
      }
    });
    jButton7.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    gridLayout1.setColumns(3);
    gridLayout1.setRows(3);
    this.getContentPane().setLayout(gridLayout1);
    this.setSize(new Dimension(242, 206));
    this.setTitle("Remote Control");
    this.addKeyListener(new java.awt.event.KeyAdapter() {

      public void keyPressed(KeyEvent e) {
        this_keyPressed(e);
      }
    });
    jButton4.setText("Left");
    jButton4.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton4_actionPerformed(e);
      }
    });
    jButton4.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    jButton5.setText("Stop");
    jButton5.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton5_actionPerformed(e);
      }
    });
    jButton5.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    jButton8.setText("Engine");
    jButton8.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton8_actionPerformed(e);
      }
    });
    jButton8.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    jButton6.setText("Right");
    jButton6.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton6_actionPerformed(e);
      }
    });
    jButton6.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    jButton1.setText("Missile");
    jButton1.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton1_actionPerformed(e);
      }
    });
    jButton1.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    jButton9.setText("Randomize");
    jButton9.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton9_actionPerformed(e);
      }
    });
    jButton9.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    jButton2.setText("Detonate");
    jButton2.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton2_actionPerformed(e);
      }
    });
    jButton2.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    jButton3.setText("Mine");
    jButton3.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        jButton3_actionPerformed(e);
      }
    });
    jButton3.addMouseListener(new java.awt.event.MouseAdapter() {

      public void mousePressed(MouseEvent e) {
        jButton_mousePressed(e);
      }
    });
    this.getContentPane().add(jButton7, null);
    this.getContentPane().add(jButton8, null);
    this.getContentPane().add(jButton9, null);
    this.getContentPane().add(jButton4, null);
    this.getContentPane().add(jButton5, null);
    this.getContentPane().add(jButton6, null);
    this.getContentPane().add(jButton1, null);
    this.getContentPane().add(jButton2, null);
    this.getContentPane().add(jButton3, null);
  }

  //Overridden so we can exit on System Close
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if(e.getID() == WindowEvent.WINDOW_CLOSING) {
      System.exit(0);
    }
  }

  public void detonateMissile()
  {
    /* setTitle("detonateMissile"); */
    primaryListener.detonateMissile();
  }

	public void toggleEngine()
  {
    /* setTitle("toggleEngine"); */
    primaryListener.toggleEngine();
  }

	public void rotateClockwise()
  {
    /* setTitle("rotateClockwise"); */
    primaryListener.rotateClockwise();
  }

	public void rotateCounterClockwise()
  {
    /* setTitle("rotateCounterClockwise"); */
    primaryListener.rotateCounterClockwise();
  }

	public void rotateStop()
  {
    /* setTitle("rotateStop"); */
    primaryListener.rotateStop();
  }

	public void launchMissile()
  {
    /* setTitle("launchMissile"); */
    primaryListener.launchMissile();
  }

	public void launchMine()
  {
    /* setTitle("launchMine"); */
    primaryListener.launchMine();
	}

	public void restartGame() {
		/* setTitle("restartGame"); */
		primaryListener.restartGame();
	}
	
	public void randomizeGame() {
		/* setTitle("randomizeGame"); */
		primaryListener.randomizeGame();
	}

  void jButton_mousePressed(MouseEvent e) {
    mousePressed = true;
  }

  void jButton1_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.launchMissile();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.launchMissile();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.launchMissile();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.launchMissile();

      return;
    }
  }

  void jButton2_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.detonateMissile();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.detonateMissile();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.detonateMissile();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.detonateMissile();

      return;
    }
  }

  void jButton3_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.launchMine();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.launchMine();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.launchMine();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.launchMine();

      return;
    }
  }

  void jButton4_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.rotateCounterClockwise();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.rotateCounterClockwise();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.rotateCounterClockwise();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.rotateCounterClockwise();

      return;
    }
  }

  void jButton5_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.rotateStop();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.rotateStop();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.rotateStop();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.rotateStop();

      return;
    }
  }

  void jButton6_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.rotateClockwise();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.rotateClockwise();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.rotateClockwise();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.rotateClockwise();

      return;
    }
  }

  void jButton7_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.restartGame();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.restartGame();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.restartGame();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.restartGame();

      return;
    }
 }

  void jButton8_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.toggleEngine();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.toggleEngine();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.toggleEngine();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.toggleEngine();

      return;
    }

  }

  void jButton9_actionPerformed(ActionEvent e) {
    // Mouse pressed
    if (mousePressed == true)
    {
      mousePressed = false;

      if (isMouseListener == true)
      {
        if (primaryListener != null)
          primaryListener.randomizeGame();

        return;
      }
      else
      {
        if (secondaryListener != null)
          secondaryListener.randomizeGame();

        return;
      }
    }

    // Keyboard pressed
    if (isKeyboardListener == true)
    {
      if (primaryListener != null)
        primaryListener.randomizeGame();

      return;
    }
    else
    {
      if (secondaryListener != null)
        secondaryListener.randomizeGame();

      return;
    }
  }

  void this_keyPressed(KeyEvent e) {
    if (e.getKeyCode() == e.VK_1 || e.getKeyCode() == e.VK_NUMPAD1)
    {
      jButton1.doClick();
      jButton1.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_2 || e.getKeyCode() == e.VK_NUMPAD2)
    {
      jButton2.doClick();
      jButton2.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_3 || e.getKeyCode() == e.VK_NUMPAD3)
    {
      jButton3.doClick();
      jButton3.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_4 || e.getKeyCode() == e.VK_NUMPAD4)
    {
      jButton4.doClick();
      jButton4.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_5 || e.getKeyCode() == e.VK_NUMPAD5)
    {
      jButton5.doClick();
      jButton5.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_6 || e.getKeyCode() == e.VK_NUMPAD6)
    {
      jButton6.doClick();
      jButton6.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_7 || e.getKeyCode() == e.VK_NUMPAD7)
    {
      jButton7.doClick();
      jButton7.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_8 || e.getKeyCode() == e.VK_NUMPAD8)
    {
      jButton8.doClick();
      jButton8.requestFocus();

      return;
    }

    if (e.getKeyCode() == e.VK_9 || e.getKeyCode() == e.VK_NUMPAD9)
    {
      jButton9.doClick();
      jButton9.requestFocus();

      return;
    }
  }
}
