// A SpaceBackgroundStars implements SpaceBackground, so that it may be
// used as a background by Universe objects.

package SpaceWar;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

class SpaceBackgroundStars implements SpaceBackground {

	//////////////////////////////////////////////////////////////////////
	//
	// Instance Variables.

	protected int numStars;
	protected Point[] stars;

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.
	
	public SpaceBackgroundStars(int newNumStars, MetricSpace metric) {
		Random rng = new Random(System.currentTimeMillis());
		int x;
		int y;

		numStars = newNumStars;
		stars = new Point[numStars];
		for (int i = 0; i < numStars; i++) {
			x = metric.fractionToX(rng.nextDouble());
			y = metric.fractionToY(rng.nextDouble());
			stars[i] = new Point(x, y);
		}
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Paint method.

	public void paint(SpaceGraphics g) {
		g.setColor(Color.white);
		for (int i = 0; i < numStars; i++) {
			g.fillOval(stars[i].x, stars[i].y, 2, 2);
		}
	}
}
