// Interface defining the portion of the Graphics object's protocol that
// is used by SpaceWar.  This interface allows the classes implementing
// it more freedom in how they use inheritence.
//
// Implementors of SpaceGraphics are examples of the Decorator pattern,
// delegating transformed operations to the Graphics class.

package SpaceWar;

import java.awt.*;

interface SpaceGraphics {

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors: an interface cannot define these, but your life
	// will be easier if your implementing classes do define these
	// constructors...

	// SpaceGraphics();
	// SpaceGraphics(SpaceGraphics g);

	//////////////////////////////////////////////////////////////////////
	//
	// Get-set methods.

	void setWrappedGraphics(Graphics g);

	//////////////////////////////////////////////////////////////////////
	//
	// Drawing methods.

	void setColor(Color c);
	void fillOval(int x, int y, int width, int height);
	void fillOval(SpacePoint ref,
		 	      double r, double theta,
			      int width, int height);
	void drawLine(int x1, int y1, int x2, int y2);
	void drawLine(SpacePoint ref,
			      double r1, double theta1,
			      double r2, double theta2);
	void drawPolygon(int[] xPoints, int[] yPoints, int nPoints);
	void fillPolygon(int[] xPoints, int[] yPoints, int nPoints);

	//////////////////////////////////////////////////////////////////////
	//
	// Specialized SpaceWar drawing methods.
	
	// Draw a speed-blur polygon between four points specified as
	// polar offsets from a pair of reference points.

	void polarBlur(SpacePoint ref1,
				   double r1a, double r1b, double theta1,
				   SpacePoint ref2,
				   double r2a, double r2b, double theta2);

	// Draw a speed-blur polygon between a pair of circles.
	
	void circleBlur(SpacePoint ref1, double r1,
					SpacePoint ref2, double r2);
}
