// Defines the SpaceMine SpaceObject.

package SpaceWar;

import java.awt.*;
import java.awt.geom.*;

class SpaceMine extends SpaceObject {

	//////////////////////////////////////////////////////////////////////
	//
	// Parameters.

	protected static double mineMass = 0.1;
	protected static double mineRadius = 4.;

	//////////////////////////////////////////////////////////////////////
	//
	// Static members.

	// Register class.

	protected static void register() {
		SpaceObjectRegistry.put("mine", new SpaceMine());
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.

	public SpaceMine() {
		setRadius(mineRadius);
		setMass(mineMass);
	}
	
	public SpaceMine(Color body, Color trim) {
		this();
		setBodyColor(body);
		setTrimColor(trim);
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Overridden methods.

	public SpaceObject cloneMe() {
		SpaceMine mine;
		
		mine = new SpaceMine();
		copyTo(mine);
		return (mine);
	}

	public void paintTrim(SpaceGraphics g) {
		g.setColor(trimColor);
		g.drawLine(displayPosition,
				   radius - 1, angle + Math.PI / 2.,
				   radius - 1, angle - Math.PI / 2.);
		g.drawLine(displayPosition,
				   radius - 1, angle,
				   radius - 1, angle + Math.PI);
	}
}
