// Defines the SpaceMissile SpaceObject.

package SpaceWar;

import java.awt.*;
import java.awt.geom.*;

class SpaceMissile extends SpaceObject {

	//////////////////////////////////////////////////////////////////////
	//
	// Parameters.

	protected static double engineThrust = 0.2; 
	protected static double missileMass = 0.5;
	protected static double missileRadius = 4.;

	//////////////////////////////////////////////////////////////////////
	//
	// Static members.

	// Register class.

	protected static void register() {
		SpaceObjectRegistry.put("missile", new SpaceMissile());
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.

	public SpaceMissile() {
		setRadius(missileRadius);
		setMass(missileMass);
		setThrust(engineThrust);
	}
	
	public SpaceMissile(Color body, Color trim) {
		this();
		setBodyColor(body);
		setTrimColor(trim);
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Overridden methods.

	public SpaceObject cloneMe() {
		SpaceMissile missile;
		
		missile = new SpaceMissile();
		copyTo(missile);
		return (missile);
	}
	
	// Ships eat unexploded missiles, as does any other object
	// that marks itself as "eating".
	
	public void startExploding(SpaceObject otherObject) {
		if ((otherObject != null) &&
		    otherObject.amEatingObject() &&
		    !amOutOfControl()) {
			stopExisting();
			return;
		}
		super.startExploding(otherObject);
	}
	
	// Missiles are "eaten" by ships and other objects that mark
	// themselves as "eaters".
	
	public boolean amEatenObject() {
		return (true);
	}

	public void paintTrim(SpaceGraphics g) { }
}
