// This is an extension (by delegation) to Iterator.  It returns
// SpaceObjects, avoiding the need to cast.  It also allows specifying
// which object to begin after, allowing a pair of
// SpaceObjectListIterators to be used to easily traverse all pairs
// of elements in a list, as is needed for collision and gravity
// computations.

package SpaceWar;

import java.util.*;

class SpaceObjectListIterator {

	//////////////////////////////////////////////////////////////////////
	//
	// Instance Variables.

	protected Iterator iter;

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.

	// Create a raw iterator, which must be sent setIterator() before
	// it can be used.

	public SpaceObjectListIterator() {
	}

	// Create an iterator for the specified linked list.

	public SpaceObjectListIterator(LinkedList ll) {
		this();
		setIterator(ll);
	}

	// Create an iterator for the specified linked list, starting after
	// the specified element of the linked list.

	public SpaceObjectListIterator(LinkedList ll,
								   SpaceObject startAfter) {
		this();
		setIterator(ll);
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Initialization methods.

	// Set this iterator to iterate over the specified linked list.

	public void setIterator(LinkedList ll) {
		iter = ll.iterator();
	}

	// Set this iterator to iterate over the specified linked list,
	// but starting after the specified SpaceObject.  Too bad that
	// Iterator does not support Cloneable...

	public void setIterator(LinkedList ll, SpaceObject startAfter) {
		setIterator(ll);
		
		while (iter.next() != startAfter) {
		}
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Delegated Iterator methods.
	
	public boolean hasNext() {
		return (iter.hasNext());
	}

	public SpaceObject next() {
		return ((SpaceObject)iter.next());
	}

	public void remove() {
		iter.remove();
	}
}
