// Extension of Point2D.Double that adds some methods to work with points
// in polar coordinates.  Polar coordinates are useful in specifying the
// form of displayed objects that can rotate, because rotation is trivial
// in polar coordinates.
//
// These added methods allow adding pre-rotated polar points to an (x,y)
// overall object position.

package SpaceWar;

import java.awt.*;
import java.awt.geom.*;

class SpacePoint extends Point {

	// Constructor.
	
	public SpacePoint(int x, int y) {
		super(x, y);
	}

	// Convert the polar point specified by (r, theta) to rectangular
	// coordinates, placing the result in the receiver.

	public void fromPolar(double r, double theta) {
		setLocation((int)(r * Math.cos(theta)),
				    (int)(r * Math.sin(theta)));
	}

	// Add the polar point specified by (r, theta) to the receiver,
	// placing the result in the reciever.

	public void addPolar(double r, double theta) {
		setLocation(getX() + (int)(r * Math.cos(theta)),
			        getY() + (int)(r * Math.sin(theta)));
	}

	// Add the polar point specified by (r, theta) to the point
	// specified by sp, placing the result in the receiver.

	public void addPolar(SpacePoint sp, double r, double theta) {
		setLocation(sp.getX() + (int)(r * Math.cos(theta)),
			    	sp.getY() + (int)(r * Math.sin(theta)));
	}
}
