// SpaceSun SpaceObject.

package SpaceWar;

import java.awt.*;
import java.awt.geom.*;

class SpaceSun extends SpaceObject {

	//////////////////////////////////////////////////////////////////////
	//
	// Parameters.

	protected static double sunMass = 1.0e12;
	protected static double sunRadius = 16.;
	protected static double novaMassRatio = 0.1;

	//////////////////////////////////////////////////////////////////////
	//
	// Static members.

	// Register class.

	protected static void register() {
		SpaceObjectRegistry.put("sun", new SpaceSun());
	}

	//////////////////////////////////////////////////////////////////////
	//
	// Constructors.

	public SpaceSun() {
		setRadius(sunRadius);
		setMass(sunMass);
		setBodyColor(Color.yellow);
		setTrimColor(Color.black);
	}


	//////////////////////////////////////////////////////////////////////
	//
	// Overridden methods.

	public SpaceObject cloneMe() {
		SpaceSun sun;
		
		sun = new SpaceSun();
		copyTo(sun);
		return (sun);
	}
	
	public void startExploding(SpaceObject otherObject) {
		
		// Object has to be sufficiently big to affect a sun.

		if (otherObject.getMass() / mass < novaMassRatio) {
			return;
		}

		super.startExploding(otherObject);
	}

	public void paintTrim(SpaceGraphics g) { }
}
