/* 
 *	StartUp.java
 *
 *	Title:			SpaceWar
 *	Description:	SpaceWar video game, patterned after Bryan Miller's
 *					and Paul McKenney's CS215 project, which was in
 *					turn patterned after MIT's SpaceWar.
 */

package SpaceWar;

import java.awt.*;
import java.awt.geom.*;
import java.util.*;

public class StartUp extends Frame {

	protected int frameHeight = 512;
	protected int frameWidth = 512;
	protected int frameMargin = 50;
	protected int minX = frameMargin;
	protected int maxX = minX + frameWidth;
	protected int minY = -frameMargin - frameHeight;
	protected int maxY = minY + frameHeight;

	SpaceSun theSun;
	SpaceShip blueShip;
	SpaceShip greenShip;
	MetricSpace metric;
	Gravity gravity;
	Universe universe;
	SpaceBackground background;
	SpaceGraphics transform;

	RemoteControl rcLeft = new RemoteControl();
	RemoteControl rcRight = new RemoteControl();
	boolean packFrame = false;

	protected Random rng = new Random(System.currentTimeMillis());

	static void main(String [] args) {
		StartUp frame;
		
		SpaceMissile.register();
		SpaceMine.register();
		SpaceShip.register();
		SpaceSun.register();
		frame = new StartUp();
		frame.show();
		frame.run();
	}

	public StartUp() {

		setTitle("SpaceWar");
		setSize(frameWidth + 2 * frameMargin,
				frameHeight + 2 * frameMargin);
		setBackground(Color.black);
		metric = new MetricSpaceEuclideanBounce(minX, maxX, minY, maxY);
		gravity = new GravityNewtonian(metric);
		background = new SpaceBackgroundStars(40, metric);
		universe = new Universe(this, metric, gravity, background);

		blueShip = (SpaceShip)SpaceObjectRegistry.clone(
						"ship", 
						metric.fractionToX(.75), metric.fractionToY(.5),
						-Math.PI / 2,
						Color.blue, Color.white);
		
		greenShip = (SpaceShip)SpaceObjectRegistry.clone(
						"ship",
						metric.fractionToX(.25), metric.fractionToY(.5),
						Math.PI / 2,
						Color.green, Color.black);

		setupObjects(1);

		transform = new SpaceGraphicsFlipCenter();
		createRemoteControl();
	}

	public void setupObjects(int restartType) {

		blueShip.setExplosionState(SpaceObject.NormalState);
		blueShip.setPosition(metric.fractionToX(.75),
							 metric.fractionToY(.5));
		blueShip.setAngle(-Math.PI / 2);
		blueShip.setAngularVelocity(0.);
		blueShip.setVelocity(0., 4.);
		blueShip.setBodyColor(Color.blue);
		blueShip.setTrimColor(Color.white);
		universe.addSpaceObject(blueShip);
		
		greenShip.setExplosionState(SpaceObject.NormalState);
		greenShip.setPosition(metric.fractionToX(.25),
							  metric.fractionToY(.5));
		greenShip.setAngle(Math.PI / 2);
		greenShip.setAngularVelocity(0.);
		greenShip.setVelocity(0., -4.);
		greenShip.setBodyColor(Color.green);
		greenShip.setTrimColor(Color.black);
		universe.addSpaceObject(greenShip);
		
		if (restartType == 1) {
			theSun = (SpaceSun)SpaceObjectRegistry.clone(
							"sun",
							metric.fractionToX(.5),
							metric.fractionToY(.5),
							0.,
							Color.yellow, Color.black);
			universe.addSpaceObject(theSun);
			return;
		}
		theSun = (SpaceSun)SpaceObjectRegistry.clone(
						"sun",
						metric.fractionToX(.5), metric.fractionToY(.6),
						0.,
						Color.yellow, Color.black);
		theSun.setVelocity(2., 0.);
		universe.addSpaceObject(theSun);

		theSun = (SpaceSun)SpaceObjectRegistry.clone(
						"sun",
						metric.fractionToX(.5), metric.fractionToY(.4),
						0.,
						Color.yellow, Color.black);
		theSun.setVelocity(-2., 0.);
		universe.addSpaceObject(theSun);
		switch (rng.nextInt(3)) {
		case 0:
			gravity = new GravityInverseNewtonian(metric);
			break;
		case 1:
			gravity = new GravityNewtonian(metric);
			break;
		case 2:
			gravity = new GravityTerrestrial(metric);
			break;
		}
		universe.setGravity(gravity);
	}

	protected void createRemoteControl() {

	    rcLeft.setAsKeyboardListener();
	    rcRight.setAsMouseListener();
	    
	    rcLeft.setPrimaryListener(greenShip);
	    rcRight.setPrimaryListener(blueShip);

	    rcLeft.setSecondaryListener(rcRight);
	    rcRight.setSecondaryListener(rcLeft);

	    //Validate frames that have preset sizes
	    //Pack frames that have useful preferred size info,
	    // e.g. from their layout
	    if (packFrame)
	      rcLeft.pack();
	    else
	      rcLeft.validate();
	    rcLeft.setVisible(true);

	    if (packFrame)
	      rcRight.pack();
	    else
	      rcRight.validate();
	    rcRight.setVisible(true);

	    rcLeft.setLocation(0, 600);
	    rcRight.setLocation(600, 600);
		}

	public void run() {
		universe.run();
	}

	public void paint(Graphics g) {
		transform.setWrappedGraphics(g);
		universe.paint(transform);
	}
}
