#include "sudoku_core.h"

char *charmap = "123456789ABCDEFGHIJKLMNOPQURSTU";

/*
 * Compute the size of the puzzle from the length of the first line.
 */

void compute_order(int linelen)
{
	ORDER = linelen / 2;
	SUBORDER = isqrt(ORDER);
	nentries = ORDER * ORDER;
	nrows = ORDER;
	ncols = ORDER;
	if ((linelen != 2 * ORDER) ||
	    (SUBORDER < 0)) {
		fprintf(stderr, "Bad first non-comment line\n");
		exit(-1);
	}
}

/*
 * Gather a vector of pointers to the set of elements in the specified row.
 */

void gather_horizontal(puzzle_entry_t *p, int li, puzzle_entry_t **h)
{
	int i;
	int j;
	int j1;

	linear_index2rowcol(li, &i, &j);
	for (j1 = 0; j1 < ORDER; j1++) {
		h[j1] = puzzle_entryp(p, i, j1);
	}
}

/*
 * Gather a vector of pointers to the set of elements in the specified column.
 */

void gather_vertical(puzzle_entry_t *p, int li, puzzle_entry_t **h)
{
	int i;
	int j;
	int i1;

	linear_index2rowcol(li, &i, &j);
	for (i1 = 0; i1 < ORDER; i1++) {
		h[i1] = puzzle_entryp(p, i1, j);
	}
}

/*
 * Gather a vector of pointers to the set of elements in the specified block.
 */

void gather_block(puzzle_entry_t *p, int li, puzzle_entry_t **h)
{
	int hidx = 0;
	int i;
	int j;
	int i1;
	int j1;
	int istart;
	int jstart;

	linear_index2rowcol(li, &i, &j);
	istart = (i / SUBORDER) * SUBORDER;
	jstart = (j / SUBORDER) * SUBORDER;
	for (i1 = istart; i1 < istart + SUBORDER; i1++) {
		for (j1 = jstart; j1 < jstart + SUBORDER; j1++) {
			h[hidx] = puzzle_entryp(p, i1, j1);
			hidx++;
		}
	}
}

gather_func_t *gather_funcs[] =
	{ gather_horizontal, gather_vertical, gather_block, NULL };

/*
 * Given the indices of an element in (i,j), compute the indices of
 * the first element of that block in (i1,j1).
 */

void idx2rowcol_block(int idx, int i, int j, int *i1, int *j1)
{
	int istart;
	int jstart;

	istart = (i / SUBORDER) * SUBORDER;
	jstart = (j / SUBORDER) * SUBORDER;
	*i1 = i + idx / SUBORDER;
	*j1 = j + idx % SUBORDER;
}
