#include "sudoku_core.h"

char *charmap = "1234567890ABCDEFGHIJKLMNOPQURST";

/*
 * Compute the size of the puzzle from the length of the first line.
 * Each row represents on radial segment of the circle.
 */

void compute_order(int linelen)
{
	ORDER = linelen / 2 * 2;
	if (ORDER % 4 == 0) {
		SUBORDER = 4;
	} else if (ORDER % 5 == 0) {
		SUBORDER = 5;
	} else if (ORDER % 3 == 0) {
		SUBORDER = 3;
	} else {
		SUBORDER = ORDER;
	}
	nrows = ORDER;
	ncols = ORDER / 2;
	nentries = nrows * ncols;
	if ((linelen != ORDER) &&
	    (linelen != ORDER + 1)) {
		fprintf(stderr, "Bad first non-comment line\n");
		exit(-1);
	}
}

/*
 * Gather a vector of pointers to the set of elements in the specified
 * pair of sectors.
 */

void gather_sectors(puzzle_entry_t *p, int li, puzzle_entry_t **h)
{
	int i;
	int j;
	int i1;
	int j1;

	linear_index2rowcol(li, &i, &j);
	for (j1 = 0; j1 < ncols; j1++) {
		h[j1] = puzzle_entryp(p, i, j1);
	}
	i1 = i + 1;
	if (i1 >= nrows) {
		i1 = 0;
	}
	for (j1 = ncols; j1 < 2 * ncols; j1++) {
		h[j1] = puzzle_entryp(p, i1, j1 - ncols);
	}
}

/*
 * Gather a vector of pointers to the set of elements in the specified
 * annular ring.
 */

void gather_annulus(puzzle_entry_t *p, int li, puzzle_entry_t **h)
{
	int i;
	int j;
	int i1;

	linear_index2rowcol(li, &i, &j);
	for (i1 = 0; i1 < ORDER; i1++) {
		h[i1] = puzzle_entryp(p, i1, j);
	}
}

gather_func_t *gather_funcs[] =
	{ gather_sectors, gather_annulus, NULL };
